import PyInstaller.__main__
import shutil
import os

# Aufräumen vorheriger Builds
for folder in ['build', 'dist', '__pycache__']:
    if os.path.exists(folder):
        shutil.rmtree(folder)

# Datei einbetten: Libre.txt → Zielpfad im MEIPASS: WinTmp/Libre.txt
data_files = [
    ('LibreHardwareMonitorLib.dll', 'WinTmp/')
]

opts = [
    'libre_check05.py',
    '--name=hardwarecheck',
    '--onefile',
    '--console',  # GUI-Modus
    #'--windowed',
    '--clean',
    '--log-level=WARN',
]

# Daten einbetten
for src, dest in data_files:
    opts.append(f'--add-data={src};{dest}')  # unter Windows: Semikolon

# Hidden-Imports
hidden_imports = [
    'WinTmp',
    'LibreHardwareMonitor',
]


for hidden in hidden_imports:
    opts.append(f'--hidden-import={hidden}')

PyInstaller.__main__.run(opts)
