import os
import time
import shutil
import tempfile
from difflib import get_close_matches
import WinTmp  
from LibreHardwareMonitor import Hardware

def best_match_optional(filter_value, target_value, cutoff=0.6):
    if not filter_value:
        return True
    return bool(get_close_matches(filter_value, [target_value], n=1, cutoff=cutoff))

def suche_sensorwerte_mit_typ(filterkriterien):
    hw = Hardware.Computer()
    hw.IsGpuEnabled = True
    hw.IsCpuEnabled = True
    hw.IsMemoryEnabled = True
    hw.IsMotherboardEnabled = True
    hw.IsStorageEnabled = True
    hw.IsNetworkEnabled = True
    hw.IsControllerEnabled = False
    hw.Open()

    treffer = []
    hardware_counter = 0

    for hardware in hw.Hardware:
        hardware.Update()

        hardware_type_str = hardware.HardwareType.ToString()
        hardware_name_str = hardware.Name
        hardware_id = f"ID{hardware_counter}"
        hardware_counter += 1

        for sensor in hardware.Sensors:
            sensor_name_str = sensor.Name
            sensor_type_str = sensor.SensorType.ToString()

            if all([
                best_match_optional(filterkriterien.get("hardware_type"), hardware_type_str),
                best_match_optional(filterkriterien.get("hardware_name"), hardware_name_str),
                best_match_optional(filterkriterien.get("sensor_name"), sensor_name_str),
                best_match_optional(filterkriterien.get("sensor_type"), sensor_type_str)
            ]):
                treffer.append({
                    "ID": hardware_id,
                    "HardwareName": hardware_name_str,
                    "HardwareType": hardware_type_str,
                    "SensorName": sensor_name_str,
                    "SensorType": sensor_type_str,
                    "Value": sensor.Value
                })

    hw.Close()
    return treffer

if __name__ == "__main__":
    suchfilter = {
        "hardware_type": "",
        "hardware_name": "",
        "sensor_name": "",
        "sensor_type": ""
    }

    results = suche_sensorwerte_mit_typ(suchfilter)

    if results:
        for r in results:
            print(f"{r['ID']} | {r['HardwareType']} | {r['HardwareName']} | Sensor: {r['SensorName']} "
                  f"({r['SensorType']}) = {r['Value']}")
            time.sleep(0.01)
    else:
        print("Keine passenden Sensorwerte gefunden.")

    input("\nCopy text, please")