# seamv1-pseudovoc
Here is the experiments of DeepLabv1 on pseudo labels generated by [SEAM](https://github.com/YudeWang/SEAM).

## Dataset
Please refer to another [repository](https://github.com/YudeWang/deeplabv3plus-pytorch) for Dataset preparation, which is an ancient version of this codebase.

Generate pseudo labels according to README in [SEAM](https://github.com/YudeWang/SEAM) repository, and set `'DATA_PSEUDO_GT': $your_pseudo_label_path` in `config.py`.

## Model
ImageNet pretrained ResNet38 model can be downloaded in [SEAM](https://github.com/YudeWang/SEAM) repository, and replace the path setting in `../../lib/net/backbone/resnet38d.py'`
| model | val mIoU |
|-------|----------|
| [deeplabv1-resnet38](https://drive.google.com/file/d/1wTJFzF6GA2FIelU7odP090NKPGGLmV8G/view?usp=sharing) | 64.754% |

## Usage
Please modify the configration in `config.py` according to your device firstly.
```
python train.py
```
Don't forget to check test configration in `config.py` then
```
python test.py
```

## Citation
Please cite our paper if the code is helpful to your research.
```
@InProceedings{Wang_2020_CVPR_SEAM,
    author = {Yude Wang and Jie Zhang and Meina Kan and Shiguang Shan and Xilin Chen},
    title = {Self-supervised Equivariant Attention Mechanism for Weakly Supervised Semantic Segmentation},
    booktitle = {Proc. IEEE Conference on Computer Vision and Pattern Recognition (CVPR)},
    year = {2020}
}
```
